import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class TextField extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean IsTextField()
	{
		return true;
	}

	@Override
	public boolean CanBeDeletedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return true;
	}

	@Override
	public boolean CanBeMovedByUser()
	{
		return true;
	}

	@Override
	public boolean CanBeSelectedByUser()
	{
		return true;
	}
	// end of DrawObject abilities

	private boolean IsBeingEdited = false;

	public TextField(Point Pos)
	{
		SetPos(Pos);
		SetSize(new Point(100, 50));
		InitializeExcitement(ExcitementOnceMilliseconds);
	};

	public void AddText(char AddText)
	{
		Text += AddText;

		AutoSize();
	};

	private void AutoSize()
	{
		Size.x = Math.max(100, 20 + Text.length() * 12);
	};

	public void Clear()
	{
		Text = "";

		AutoSize();
	}

	@Override
	public void Draw(Graphics g)
	{
		if (!(IsWithinWindowBounds(this, 0)))
			return;

		// background (overdraw grid)
		if (IsHighlighted || IsPartOfMultiSelection)
			SetColor(g, Color.GREEN);
		else if (IsCommentField)
			SetColor(g, Color.LIGHT_GRAY);
		else
			SetColor(g, Color.LIGHT_GRAY);
		FillRect(g, Pos.x, Pos.y, Size.x, Size.y);

		// frame
		if (IsBeingEdited)
			SetColor(g, Color.MAGENTA);
		else if (IsCommentField)
			SetColor(g, GetExcitementColor(Color.BLUE));
		else
			SetColor(g, GetExcitementColor(Color.BLACK));
		if (IsCommentField)
			DrawThickRect(g, Pos.x, Pos.y, Size.x, Size.y);
		else
			DrawRect(g, Pos.x, Pos.y, Size.x, Size.y);

		// text
		if (IsBeingEdited)
			SetColor(g, Color.MAGENTA);
		else if (IsCommentField)
			SetColor(g, Color.BLACK);
		else
			SetColor(g, GetExcitementColor(Color.BLACK));

		g.setFont(GetDefaultFont());
		DrawString(g, Text, Pos.x + 10, Pos.y + 32);
	}

	public boolean GetBeingEdited()
	{
		return IsBeingEdited;
	}

	protected String GetText()
	{
		return Text;
	}

	public void RemoveOneLetter()
	{
		if (Text.length() >= 1)
			Text = Text.substring(0, Text.length() - 1);

		AutoSize();
	}

	public void SetBeingEdited(boolean IsBeingEditedNew)
	{
		IsBeingEdited = IsBeingEditedNew;
	}

	protected void SetText(String TextNew)
	{
		if (TextNew != null && TextNew.length() >= 1 && TextNew.length() < 1000)
			Text = TextNew;
		else
			System.out.println("error in TextField.SetText(): passed value not useful!");

		AutoSize();
	}
}
